//////////////////// 浏览器事件定义js->c++ ///////////////////
const ev_close = 0;         // 关闭程序
const ev_min = 1;           // 最小化窗口
const ev_mousedown = 2;
const ev_mousemove = 3;
const ev_mouseup = 4;
const ev_reload = 5;        // 重新装载
const ev_ready = 6;     
const ev_resize = 7;  
const ev_center = 8;
const ev_title = 9; 
/////////////////////////////////////////////////////////////

//////////////////// 浏览器事件定义c++->js ///////////////////

/////////////////////////////////////////////////////////////
// (function () {
//     window.postMessage({type: ev_ready});
//     window.postMessage({type: ev_resize, data: {width: 1100, height: 700}});
//     window.postMessage({type: ev_center});
//     window.postMessage({type: ev_title, data:{title: "顺网云电脑"}});
// })();

window.onload = () => {
    let btnClose = document.getElementById('close');
    if (btnClose !== null) {
        btnClose.onclick = () => {
            window.postMessage({type: ev_close});
        }
    }
    
    let btnMin = document.getElementById('min');
    if (btnMin !== null) {
        btnMin.onclick = () => {
            window.postMessage({type: ev_min});
        }
    }

    let title = document.getElementById('title');
    if (title !== null) {
        title.onmousedown = () => {
            window.postMessage({type: ev_mousedown});
            title.setPointerCapture(1);
        };
        title.onmousemove = () => {
            window.postMessage({type: ev_mousemove});
        };
        title.onmouseup = () => {
            window.postMessage({type: ev_mouseup});
            title.releasePointerCapture(1);
        };
    }

    // 刷新按钮
    let btnRefresh = document.getElementById('flush');
    if (btnRefresh !== null) {
        btnRefresh.onclick = () => {
            window.postMessage({type: ev_reload});
        }
    };
};