// 支持QT而创建的对象
window.qt = {webChannelTrasnport:{}};

// 支持QT创建通信
function QWebChannel(transport, initCallback) {
    if (initCallback === undefined) {
        console.log('QWebChannel callback is undefined');
        return;
    }

    let channel = {
        objects: {
            swcontext: {
                sendMessage: (param, callback) => {
                    window._sendPackage(JSON.parse(param), callback);
                },
                sendSysMessage: (param, callback) => {
                    window._sendPackage(JSON.parse(param), callback);
                },
                SetSessionId: (param, callback) => {
                    let package = {type:0x000E, session:param};
                    window._sendPackage(package, callback);
                },
                getData: (type, k, callback) => {
                    let package = {type:0x006C, data:{type: type, key: k}};
                    window._sendPackage(package, callback);
                },

            } 
        }
    }
    initCallback(channel);
}

// 发送消息给客户端
window._sendPackage = async (param, callback) => {
    const promise =  window.postMessage(param);
    let ret = await promise;
    if (callback instanceof Function) {
        callback?.call(this, ret);
    }
}